// Enter your examination number here

unit Question3_U;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, ComCtrls, Buttons;

type
  TfrmQ3 = class(TForm)
    redQ3GameBoard: TRichEdit;
    rgbQ3: TRadioGroup;
    btnQ3_1StartGame: TButton;
    btnClose: TBitBtn;
    btnQ3_2Play: TButton;
    cmbRow: TComboBox;
    cmbCol: TComboBox;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    redQ3Incorrect: TRichEdit;
    btnQ3_3Reveal: TButton;
    Label5: TLabel;
    pnlQ3NumberOfGuesses: TPanel;
    pnlPlay: TPanel;
    procedure btnQ3_1StartGameClick(Sender: TObject);
    procedure btnQ3_2PlayClick(Sender: TObject);
    procedure btnQ3_3RevealClick(Sender: TObject);
  private
    { Private declarations }
    procedure display;
  public
    { Public declarations }
  end;

var
  frmQ3: TfrmQ3;
  iNum: integer;
  iFound: integer = 0;
  iCount: integer;
  // Provided code
  aGame: array [1 .. 9, 1 .. 9] of char;

implementation

{$R *.dfm}
{$R+}

procedure TfrmQ3.btnQ3_1StartGameClick(Sender: TObject);
  var
    iLevel, iRow, iCol: integer;
  begin
    iLevel := rgbQ3.ItemIndex;
    case iLevel of
      0:
        iNum := 50;
      1:
        iNum := 40;
      2:
        iNum := 30;
    end;
    iFound := 0;
    iCount := 0;
    pnlQ3NumberOfGuesses.Caption := IntToStr(iFound);
    btnQ3_2Play.Enabled := true;
    redQ3Incorrect.Clear;
    cmbRow.ItemIndex := 0;
    cmbCol.ItemIndex := 0;

    for iRow := 1 to Length(aGame) do
      begin
        for iCol := 1 to Length(aGame) do
          begin
            aGame[iRow, iCol] := '-';
          end;
      end;
    while iNum <> 0 do
      begin
        iRow := random(9) + 1;
        iCol := random(9) + 1;
        if (aGame[iRow, iCol] = '-') then
          begin
            aGame[iRow, iCol] := '#';
            dec(iNum);
          end;
      end;
    display;
  end;

procedure TfrmQ3.btnQ3_2PlayClick(Sender: TObject);
  var
    iRow, iCol: integer;
    cChar: char;
  begin
    iRow := StrToInt(cmbRow.text);
    iCol := StrToInt(cmbCol.text);
    cChar := aGame[iRow, iCol];
    Inc(iCount);
    if cChar = '#' then
      begin
        aGame[iRow, iCol] := 'Y';
        Inc(iFound);
      end
    else
      begin
        redQ3Incorrect.Lines.Add('R' + IntToStr(iRow) + ', C' + IntToStr(iCol));
      end;
    display;
    pnlQ3NumberOfGuesses.Caption := IntToStr(iCount);
    if (iFound >= 2) AND (iCount <= 5) then
      begin
        btnQ3_2Play.Enabled := false;
        ShowMessage('Game won');
      end;
    if (iCount >= 5) AND (btnQ3_2Play.Enabled) then
      begin
        btnQ3_2Play.Enabled := false;
        ShowMessage('Game lost');
      end;
  end;

procedure TfrmQ3.btnQ3_3RevealClick(Sender: TObject);
  var
    iRow, iCol: integer;
    sLine: String;
  begin
    redQ3GameBoard.Clear;
    for iRow := 1 to Length(aGame) do
      begin
        sLine := '';
        for iCol := 1 to Length(aGame) do
          begin
            sLine := sLine + aGame[iRow, iCol] + ' ';
          end;
        redQ3GameBoard.Lines.Add(sLine);
      end;
  end;

procedure TfrmQ3.display;
  var
    iRow, iCol: integer;
    sLine: String;
  begin
    redQ3GameBoard.Clear;
    for iRow := 1 to Length(aGame) do
      begin
        sLine := '';
        for iCol := 1 to Length(aGame) do
          begin
            if aGame[iRow, iCol] = '$' then
              sLine := sLine + '# '
            else
              sLine := sLine + '- ';
          end;
        redQ3GameBoard.Lines.Add(sLine);
      end;
  end;

end.
